% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc_plot.R
\name{lc_plotnni}
\alias{lc_plotnni}
\title{Plot National Nutrient Inventory data for lakes}
\usage{
lc_plotnni(comid, include.nue = FALSE)
}
\arguments{
\item{comid}{Identifier of lake COMID user wants to plot NNI data for. Must be a character string
with the COMID digit.
Syntax: com=<COMID>}

\item{include.nue}{Include time series of nitrogen use efficiency in the returned plot. 
The default value is false. 
Values: true|false}
}
\value{
Return plot as an object.
}
\description{
Function to plot time series of nitrogen and phosphorus budgets for a given lake
COMID. This function allows a user to return a time series of major inputs, 
outputs, and derived metrics of nitrogen and phosphorus. Plot is returned as an 
object
}
\examples{
\dontrun{
p <- lc_plotnni(comid='23794487')
p <- lc_plotnni(comid='23794487', include.nue=TRUE)
}
}
\author{
Selia Markley
}
