% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliner.R
\name{outliner}
\alias{outliner}
\title{Find the points of a litholog that are along a given vertical line}
\usage{
outliner(log, xy, add = F)
}
\arguments{
\item{log}{a "litholog()"-like data frame}

\item{xy}{the intensity value for the vertical line}

\item{add}{whether to have the interpolated points added to the litholog}
}
\value{
a data frame of the extracted vertical line or the litholog with
points along this line wherever the log intersects the vertical line, with
its i (bed identification), dt (depth/time), and xy (intensity).
}
\description{
Through interpolation, this function identifies all the points
of a litholog that are at a given intensity value, along a vertical line.
}
\examples{
l <- c(1,2,3,4,5)  # left boundary of the bed interval (upper or lower)
r <- c(0,1,2,3,4)  # right boundary of the bed interval (upper or lower)
h <- c(4,3,5,3,4) # hardness (arbitrary)
i <- c("B1","B2","B3","B4","B5") # Bed name

olog <- litholog(l,r,h,i) # Generate data frame of the polygons
                          # making the litholog

log <- weldjoint(olog, c(1 ,4, 5), oufti99,
                 sym = c("1sin", "liquefaction", "1sin"),
                 ymax  = c(NA, 0.2, 0.2),
                 xmin  = c(0, 1, 0),
                 xmax  = c(4, 1.5, 3))

log_line <- outliner(log, 2)

plot.new()
plot.window(xlim = c(0,5), ylim = c(0,5))

axis(1)
axis(2)

multigons(log$i, log$xy, log$d)

points(log_line$xy, log_line$dt, pch = 19, col = "red")

}
