% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incfix.R
\name{incfix}
\alias{incfix}
\title{Fix Inclination}
\usage{
incfix(dec, inc, hsphere = "b")
}
\arguments{
\item{dec}{declination of the data; it is the angle from the north
taken on an horizontal plane. It is measured clockwise from North and ranges
from 0 to 360° (Tauxe 2010). Values outside this range are corrected by this
function.}

\item{inc}{inclination of the data; it is the angle from the
horizontal, is positive downward, and ranges from +90° for straight down to
-90° for straight up (Tauxe, 2010). Values outside this range are corrected
by this function.}

\item{hsphere}{the hemisphere onto which to project the data. Either
"b" for both. This is the default and useful for paleomagnetism. In this
case positive and negative values of inc are permitted. Or "l" for lower, and
"u" for upper, allowing only negative or positive inc values respectively.}
}
\description{
Fix inclination and declination so that they fall in the correct
quadrant and hemisphere (modified from RFOC package)
}
\details{
Quadrants are determined by the sine and cosine of the dip angle:
co = cos(dip), si = sin(dip),
quad[co>=0 & si>=0] = 1, quad[co<0 & si>=0] = 2,
quad[co<0 & si<0] = 3 and quad[co>=0 & si<0] = 4.
Samples at inc == 0° and inc == 90° are taken as exceptions (cf. code).
Be cautions with the floating point error however, round if needed.
}
\examples{
incfix(591,-425,"b")
incfix(591,-425,"u")
incfix(591,-425,"l")

}
\seealso{
\code{\link{fmod}}, \code{\link{dipfix}} and
\code{\link{transphere}}
}
