% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-PERFORMANCE.R
\docType{methods}
\name{MDD}
\alias{MDD}
\alias{MDD,Strategy-method}
\title{Strategy Performance Maximum Drawdown}
\usage{
MDD(object, of="portfolio"
       , from=NULL, until=NULL, which=NULL
       , type="relative", include.costs=TRUE
       , use.backtest=FALSE)

\S4method{MDD}{Strategy}(object, of = c("portfolio", "assets"), from = NULL,
  until = NULL, which = NULL, type = c("absolute", "relative"),
  include.costs = TRUE, use.backtest = FALSE)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{of}{Maximum Drawdown to be calculated for assets separately or the portfolio.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which performance shall be considered. If \code{NULL}, no restriction is made.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which performance shall be considered. If \code{NULL}, no restriction is made.}

\item{which}{Names or number of assets that should be included in calculation.}

\item{type}{If the \code{absolute} or \code{relative} drawdown of the performance shall be returned.}

\item{include.costs}{If \code{FALSE}, the fixed and relative trading costs are NOT considered for performance calculation. Default value is \code{TRUE}. As default values for costs are \code{0}, this argument is obsolete if no costs are given.}

\item{use.backtest}{If set to \code{TRUE}, the signals from the backtesting output are considered for maximum drawdown calculation. If \code{FALSE}, the signals from the initial strategy execution are used.}
}
\description{
Gets the maximum drawdown of the performance of an object of class \code{Strategy}.
}
\examples{
## Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Get MDD of MA(200)-Strategy portfolio
MDD(myStrat.MA, from="2015-01-01", until="2015-12-31")

# Get MDD of MA(200)-Strategy (daily data = 252 trading days)
# MDD(myStrat.MA, from="2015-01-01", until="2015-12-31", use.backtest=TRUE)

## End(Not run)
}
