% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rStempCens.R
\name{rnStempCens}
\alias{rnStempCens}
\title{Censored spatio-temporal data simulation}
\usage{
rnStempCens(x, time, coords, beta, phi, rho, tau2, sigma2,
  type.S = "exponential", kappa = 0, cens = "left", pcens = 0.1,
  lod = NULL)
}
\arguments{
\item{x}{design matrix of dimensions \eqn{nt x p}.}

\item{time}{vector containing the unique time points at which the observations are made, of length \eqn{t}.}

\item{coords}{2D unique spatial coordinates of dimension \eqn{n x 2}.}

\item{beta}{linear regression parameters.}

\item{phi}{value of the spatial scaling parameter.}

\item{rho}{value of the time scaling parameter.}

\item{tau2}{value of the the nugget effect parameter.}

\item{sigma2}{value of the partial sill.}

\item{type.S}{type of spatial correlation function: '\code{exponential}' for exponential, '\code{gaussian}' for gaussian,
'\code{matern}' for matern, '\code{pow.exp}' for power exponential and '\code{spherical}' for spherical function, respectively.
See the analytical expressions of these functions in \code{\link{EffectiveRange}}.}

\item{kappa}{parameter for all spatial covariance functions. In the case of exponential, gaussian and spherical function \eqn{\kappa} is equal to zero.
For the power exponential function \eqn{\kappa} is a number between 0 and 2. For the matern correlation function is upper than 0.}

\item{cens}{'\code{left}' or '\code{right}' censoring. By default='\code{left}'.}

\item{pcens}{desired censoring rate. By default=\code{0.10}.}

\item{lod}{desired detection limit for censored observations. By default=\code{NULL}.}
}
\value{
The function returns a data.frame containing the simulated data.
}
\description{
It simulates balanced censored spatio-temporal data with a linear structure for an established censoring rate o limit of detection.
}
\examples{
set.seed(1000)
# Initial parameter values
phi  <- 5
rho  <- 0.45
tau2 <- 0.80
sigma2 <- 2
beta   <- c(1, 2.5)
x <- cbind(1, rnorm(50))

# Coordinates
coords <- matrix(runif(20, 0, 10), ncol=2) # Cartesian coordinates without repetitions
time   <- 1:5  # Time index without repetitions

# Data simulation
data <- rnStempCens(x, time, coords, beta, phi, rho, tau2, sigma2,
                    type.S="exponential", cens="left", pcens=0.10)
}
\author{
Katherine L. Valeriano, Victor H. Lachos and Larissa A. Matos
}
