% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOCbyPT.R
\name{SOCbyPT}
\alias{SOCbyPT}
\title{SOC → PT summary by treatment (wide), with optional BY-grouping, SOC totals, UNCODED positioning, BY-specific Big-N, and optional Big-N printing}
\usage{
SOCbyPT(
  indata,
  dmdata,
  pop_data = NULL,
  group_vars,
  trtan_coln,
  by_var = NULL,
  by_sort_var = NULL,
  by_sort_numeric = TRUE,
  id_var = "USUBJID",
  rtf_safe = TRUE,
  indent_str = "(*ESC*)R/RTF\\"\\\\li360 \\"",
  use_sas_round = FALSE,
  header_blank = FALSE,
  soc_totals = FALSE,
  total_label = "TOTAL SUBJECTS WITH AN EVENT",
  uncoded_position = c("count", "last"),
  bigN_by = NULL,
  print_bigN = FALSE
)
}
\arguments{
\item{indata}{AE-like input with at least: subject id, SOC, PT, and the main treatment column.
If BY is used, \code{by_var} (and \code{by_sort_var} if different) must exist in \code{indata}.}

\item{dmdata}{Working denominator dataset (e.g., filtered ADSL) with at least: subject id and the main treatment column.
If \code{bigN_by = "YES"} and BY is used, \code{dmdata} must also contain \code{by_var} to compute BY-specific denominators.}

\item{pop_data}{Master population dataset (e.g., full ADSL) used to define the set/order of treatment arms.
If \code{NULL}, defaults to \code{dmdata}.}

\item{group_vars}{Character vector of length 3: \code{c(main_treatment, SOC, PT)}.}

\item{trtan_coln}{Treatment level value (e.g., \code{"12"} or \code{12}) that drives sorting (descending count, then alpha).}

\item{by_var}{Optional BY column name (quoted or unquoted) from \code{indata} used to split the table into groups.}

\item{by_sort_var}{Optional column (quoted or unquoted) used to order BY groups. Defaults to \code{by_var}.}

\item{by_sort_numeric}{If \code{TRUE}, BY groups ordered by \code{as.numeric(by_sort_var)}; else lexicographic.}

\item{id_var}{Subject identifier column name. Default \code{"USUBJID"}.}

\item{rtf_safe}{If \code{TRUE}, PT labels are prefixed by \code{indent_str}. Default \code{TRUE}.}

\item{indent_str}{Prefix added to PT labels when \code{rtf_safe = TRUE}.}

\item{use_sas_round}{If \code{TRUE}, use SAS-style rounding (ties away from zero). Default \code{FALSE}.}

\item{header_blank}{If \code{TRUE}, blank treatment cells on SOC header rows (TOTAL rows remain populated). Default \code{FALSE}.}

\item{soc_totals}{If \code{TRUE}, SOC header rows are retained/populated (default behavior). Included for API parity.}

\item{total_label}{Label for TOTAL row(s). Default \code{"TOTAL SUBJECTS WITH AN EVENT"}.}

\item{uncoded_position}{Where to place UNCODED: \code{"count"} (default behavior by counts) or \code{"last"} (push to bottom).}

\item{bigN_by}{Flag controlling denominator behavior when BY is used:
\itemize{
\item \code{NULL} / \code{"NO"} (default): denominators are by treatment only (not stratified by BY)
\item \code{"YES"}: denominators are by BY × treatment (requires \code{by_var} in \code{dmdata})
}}

\item{print_bigN}{If \code{TRUE}, prints denominators (Big-N) used for percent calculations to console/log.}
}
\value{
A tibble with columns:
\itemize{
\item \code{stat}
\item \verb{trt*} treatment columns
\item \code{sort_ord}, \code{sec_ord}
\item \code{by_var}, \code{by_sort_var} (when BY used)
}
}
\description{
Build a System Organ Class (SOC) → Preferred Term (PT) summary by treatment in a wide
layout suitable for clinical TLFs. Optionally stratify the display by a BY variable
from the AE dataset, order BY groups by a separate key, add TOTAL rows, control
UNCODED placement, and optionally calculate percentages using BY-specific denominators.
}
\examples{

library(dplyr)


adae <- tibble::tribble(
  ~USUBJID, ~TRTAN, ~AEBODSYS,          ~AEDECOD,
  "01",       11,   "GASTROINTESTINAL", "NAUSEA",
  "01",       11,   "GASTROINTESTINAL", "VOMITING",
  "02",       11,   "NERVOUS SYSTEM",   "HEADACHE",
  "03",       12,   "GASTROINTESTINAL", "NAUSEA",
  "04",       12,   "NERVOUS SYSTEM",   "DIZZINESS",
  "05",       12,   "UNCODED",          "UNCODED"
)

adsl <- tibble::tribble(
  ~USUBJID, ~TRTAN,
  "01",       11,
  "02",       11,
  "03",       12,
  "04",       12,
  "05",       12
)

out1 <- SOCbyPT(
  indata     = adae,
  dmdata     = adsl,
  group_vars = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln = "12"   # reference arm for sorting
)

out1




out2 <- SOCbyPT(
  indata       = adae,
  dmdata       = adsl,
  group_vars   = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln   = "12",
  rtf_safe     = FALSE,
  header_blank = TRUE
)

out2



adae_sex <- tibble::tribble(
  ~USUBJID, ~TRTAN, ~SEX, ~AEBODSYS,          ~AEDECOD,
  "01",       11,   "M",  "GASTROINTESTINAL", "NAUSEA",
  "02",       11,   "F",  "GASTROINTESTINAL", "VOMITING",
  "03",       12,   "M",  "NERVOUS SYSTEM",   "HEADACHE",
  "04",       12,   "F",  "NERVOUS SYSTEM",   "DIZZINESS",
  "05",       12,   "F",  "UNCODED",          "UNCODED"
)

adsl_sex <- tibble::tribble(
  ~USUBJID, ~TRTAN, ~SEX,
  "01",       11,   "M",
  "02",       11,   "F",
  "03",       12,   "M",
  "04",       12,   "F",
  "05",       12,   "F"
)

out3 <- SOCbyPT(
  indata           = adae_sex,
  dmdata           = adsl_sex,
  group_vars       = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln       = "12",
  by_var           = "SEX",
  by_sort_var      = "SEX",
  by_sort_numeric  = FALSE,
  uncoded_position = "last"
)

out3



out4 <- SOCbyPT(
  indata      = adae_sex,
  dmdata      = adsl_sex,
  group_vars  = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln  = "12",
  by_var      = "SEX",
  bigN_by     = "YES",
  print_bigN  = TRUE
)

out4


out4_trtN <- SOCbyPT(
  indata     = adae_sex,
  dmdata     = adsl_sex,
  group_vars = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln = "12",
  by_var     = "SEX",
  bigN_by    = "NO",
  print_bigN = TRUE
)

out4_trtN



pop_adsl <- tibble::tribble(
  ~USUBJID, ~TRTAN,
  "01",       11,
  "02",       11,
  "03",       12,
  "04",       12,
  "05",       13
)

out5 <- SOCbyPT(
  indata     = adae,
  dmdata     = adsl,
  pop_data   = pop_adsl,
  group_vars = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln = "12"
)


}
