% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatICAR.R
\name{spatICAR}
\alias{spatICAR}
\title{Generate Spatial Random Fields from ICAR Models}
\usage{
spatICAR(W, sig = 1)
}
\arguments{
\item{W}{Numeric matrix. The adjacency matrix representing the adjacency relationships between spatial units.
It can be provided by using the function `generate_adjacency_matrix`.}

\item{sig}{Numeric. The variance of the spatial random effects from the ICAR model. Must be positive.
Default value is 1.}
}
\value{
A numeric vector representing the spatial random field from the ICAR model.
        The length of the vector is equal to the number of spatial units (columns in the adjacency matrix).
}
\description{
This function generates spatial random fields from Intrinsic Conditional Autoregressive (ICAR)
models for lattice spatial data. Given an adjacency matrix and a variance parameter, the function
produces a spatial random field from the ICAR model.
}
\details{
The function starts by computing the degree of each spatial unit (number of neighbors) from the adjacency matrix.
Then, it constructs the precision matrix (Q) based on the adjacency matrix. The function computes the eigenvalues and eigenvectors of Q.
To generate the spatial random field, it uses a standard normal distribution to generate a vector of random numbers,
scales the random numbers by the variance and the inverse of the eigenvalues (excluding the smallest eigenvalue), and then transforms
the random numbers using the eigenvectors. The function returns a spatial random field vector.
}
\examples{
# Define an adjacency matrix for 5 spatial units
W <- rAdj(n = 5, p = 0.2)

# Generate spatial random field from ICAR model with variance = 1
spatial_random_field_icar <- spatICAR(W = W, sig = 1)
print(spatial_random_field_icar)

}
