% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Poislat.R
\name{Poislat}
\alias{Poislat}
\title{Fit Poisson Spatial Model}
\usage{
Poislat(
  Y,
  ID,
  W = NULL,
  shapefile = NULL,
  covariate = NULL,
  family = c("gpoisson", "poisson", "zeroinflatedpoisson0", "zeroinflatedpoisson1")
)
}
\arguments{
\item{Y}{Vector of response variables (counts).}

\item{ID}{Vector of indexes of regions (spatial units).}

\item{W}{Optional adjacency matrix representing spatial connections between regions.
If not provided, it can be generated from a shapefile using the `shapefile` argument.}

\item{shapefile}{Optional shapefile representing the study region. If provided, the adjacency matrix (`W`)
will be calculated from the shapefile.}

\item{covariate}{Optional matrix of covariates. If not provided, the function assumes the model
is intercept-only.}

\item{family}{The family of Poisson models to use. Options are "gpoisson", "poisson",
"zeroinflatedpoisson0", and "zeroinflatedpoisson1".}
}
\value{
An object of class "inla" representing the fitted Poisson spatial model.
        The object contains model estimates, diagnostics, and other results.
}
\description{
This function fits a Poisson spatial model (including zero-inflated and gamma Poisson variations)
to a given dataset using the INLA package. It constructs the formula based on the provided covariate data and ID variables,
and fits the model using the specified adjacency matrix (`W`) or a shapefile of the study region.
}
\examples{
\donttest{
  # Generate data from the GC spatial regression model with lattice spatial dependency
  W <- rAdj(500) # Generate a random adjacency matrix
  DDl <- rGClat(n = 200, alpha = 1, beta0 = 0.3, beta = c(-0.5, 0.5),
  W = W, spatial = "lattice", V = 1)

  # Prepare the data
  Y <- DDl$y
  covariate <- DDl$covariate
  ID <- DDl$ID

  # Fit the spatial Poisson model
  ResultPoisson <- Poislat(Y = Y, ID = ID, covariate = covariate, W = W, family = "poisson")

  # Summary of the model fit
  summary(ResultPoisson)
}

}
