% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SICAmain.R
\name{relax_and_split_ICA}
\alias{relax_and_split_ICA}
\title{Relax-and-split ICA Function for Sparse ICA wrapper}
\usage{
relax_and_split_ICA(
  xData,
  n.comp,
  nu = 1,
  U.list = NULL,
  whiten = c("eigenvec", "sqrtprec", "none"),
  lngca = FALSE,
  orth.method = c("svd", "givens"),
  method = c("C", "R"),
  restarts = 40,
  use_irlba = TRUE,
  eps = 1e-06,
  maxit = 500,
  verbose = FALSE,
  converge_plot = FALSE,
  col.stand = TRUE,
  row.stand = FALSE,
  iter.stand = 5,
  positive_skewness = TRUE
)
}
\arguments{
\item{xData}{A numeric matrix of input data with dimensions P x T, where P is the number of features and T is the number of samples.}

\item{n.comp}{An integer specifying the number of components to estimate.}

\item{nu}{A numeric tuning parameter controlling the balance between accuracy and sparsity of the results. It can be selected using a BIC-like criterion or based on expert knowledge. Default is 1.}

\item{U.list}{An optional matrix specifying the initialization of the U matrix. Default is \code{NULL}.}

\item{whiten}{A character string specifying the method for whitening the input \code{xData}. Options are \code{"eigenvec"}, \code{"sqrtprec"}, \code{"lngca"}, or \code{"none"}. Default is \code{"eigenvec"}.}

\item{lngca}{A logical value indicating whether to perform Linear Non-Gaussian Component Analysis (LNGCA). Default is \code{FALSE}.}

\item{orth.method}{A character string specifying the method used for generating initial values for the U matrix. Default is \code{"svd"}.}

\item{method}{A character string specifying the computation method. If \code{"C"} (default), C code is used for most computations for better performance. If \code{"R"}, computations are performed entirely in R.}

\item{restarts}{An integer specifying the number of random initializations for optimization. Default is 40.}

\item{use_irlba}{A logical value indicating whether to use the \code{irlba} method for fast truncated Singular Value Decomposition (SVD) during whitening. This can improve memory efficiency for intermediate datasets. Default is \code{TRUE}.}

\item{eps}{A numeric value specifying the convergence threshold. Default is \code{1e-6}.}

\item{maxit}{An integer specifying the maximum number of iterations for the Sparse ICA method using Laplace density. Default is 500.}

\item{verbose}{A logical value indicating whether to print convergence information during execution. Default is \code{FALSE}.}

\item{converge_plot}{A logical value indicating whether to generate a line plot showing the convergence trace. Default is \code{FALSE}.}

\item{col.stand}{A logical value indicating whether to standardize columns. For each column, the mean of the entries in the column equals 0, and the variance of the entries in the column equals 1. Default is \code{TRUE}.}

\item{row.stand}{A logical value indicating whether to standardize rows. For each row, the mean of the entries in the row equals 0, and the variance of the entries in the row equals 1. Default is \code{FALSE}.}

\item{iter.stand}{An integer specifying the number of iterations for achieving both row and column standardization when \code{col.stand = TRUE} and \code{row.stand = TRUE}. Default is 5.}

\item{positive_skewness}{A logical value indicating whether to enforce positive skewness on the estimated components. Default is \code{TRUE}.}
}
\value{
A list containing the following elements:
\describe{
  \item{\code{loglik}}{The minimal log-likelihood value among the random initializations.}
  \item{\code{estS}}{A numeric matrix of estimated sparse independent components with dimensions P x Q.}
  \item{\code{estU}}{The estimated U matrix with dimensions Q x Q.}
  \item{\code{estM}}{The estimated mixing matrix with dimensions Q x T.}
  \item{\code{whitener}}{The whitener matrix used for data whitening.}
  \item{\code{converge}}{Convergence information for the U matrix.}
}
}
\description{
This function performs Sparse Independent Component Analysis (Sparse ICA), implemented in both pure R and RCpp for efficiency.
}
