% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{self_identified_LR}
\alias{self_identified_LR}
\title{Identify Possible Ligand-Receptor Pairs for Cell-Cell Communication}
\usage{
self_identified_LR(
  DB_dataframe,
  gene_spot_expression_dataframe,
  percentage = NULL
)
}
\arguments{
\item{DB_dataframe}{A dataframe contains the columns of "ligand", "receptor" and "interaction_name}

\item{gene_spot_expression_dataframe}{A gene expression data frame with genes as row names and Spot IDs as column names. This data frame is used to verify the presence of all genes involved in the L-R pairs.}

\item{percentage}{A numeric value specifying the minimum percentage of spots in which a gene must be expressed to be considered. The default is 10.}
}
\value{
A list containing:
\describe{
  \item{possible_L_R_pairs}{A data frame of L-R pairs where all genes are present in the 'gene_spot_expression_dataframe' and meet the expression threshold. The data frame includes the ligand and receptor vectors, and the combined gene vectors.}
  \item{possible_L_R_pairs_details}{A data frame with detailed information about the identified L-R pairs, including their original annotations from the ICELLNET dataset.}
}
}
\description{
Self_identified Database: This function identifies possible ligand-receptor (L-R) pairs for cell-cell communication analysis using data from the self identified database. It checks for the presence of all genes involved in each L-R pair within the provided gene expression matrix, filtering based on a specified expression percentage threshold.
}
\examples{
library(SpaCCI)
#Load the example data
data(test_data)
#Load the example self-identified database
#(for more instructions please check the online tutorial)
data(DB_dataframe)
gene_spot_df <- test_data$gene_spot_df
result <- self_identified_LR( DB_dataframe = DB_dataframe,
                              gene_spot_expression_dataframe = gene_spot_df)

}
