% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcOutlierMap.R
\name{calcOutlierMap}
\alias{calcOutlierMap}
\alias{print.outlier_map}
\title{Calculate MAD Outlier Map}
\usage{
calcOutlierMap(
  data,
  anno_tbl = NULL,
  apt.order = c(NA, "dilution", "signal"),
  sample.order = NULL,
  fc.crit = 5
)

\method{print}{outlier_map}(x, ...)
}
\arguments{
\item{data}{A \code{soma_adat} object containing RFU feature data.}

\item{anno_tbl}{An annotations table produced via \code{\link[=getAnalyteInfo]{getAnalyteInfo()}}.
Used to calculate analyte dilutions for the matrix column ordering.
If \code{NULL}, a table is generated internally from \code{data} (if possible), and
the analytes are plotted in dilution order.}

\item{apt.order}{Character. How should the columns/features be ordered?
Options include: by dilution mix ("dilution"), by median overall signal
("signal"), or as-is in \code{data} (default).}

\item{sample.order}{Either a character string indicating the column name
with entries to be used to order the data frame rows, or a numeric vector
representing the order of the data frame rows. The
default (\code{NULL}) leaves the row ordering as it is in \code{data}.}

\item{fc.crit}{Integer. The fold change criterion to evaluate. Defaults to 5x.}

\item{x}{An object of class \code{"outlier_map"}.}

\item{...}{Arguments for S3 print methods.}
}
\value{
A list of class \code{c("outlier_map", "Map")} containing:
\item{matrix}{A boolean matrix of \code{TRUE/FALSE} whether each sample is an
outlier according the the stated criteria.}
\item{x.lab}{A character string containing the plot x-axis label.}
\item{title}{A character string containing the plot title.}
\item{rows.by.freq}{A logical indicating if the samples are ordered
by outlier frequency.}
\item{class.tab}{A table containing the frequencies of each class if input
\code{sample.order} is defined as a categorical variable.}
\item{sample.order}{A numeric vector representing the order of the data
frame rows.}
\item{legend.sub}{A character string containing the plot legend subtitle.}
}
\description{
Calculate the median absolute deviation (statistical) outliers measurements
and fold-change criteria from an ADAT. Two values are required for the
calculation: median absolute deviation (MAD) and fold-change (FC). Outliers
are determined based on the result of \emph{both} \code{6*MAD} and \code{x*FC} , where \code{x}
is the number of fold changes defined.
}
\details{
For the S3 plotting method, see \code{\link[=plot.Map]{plot.Map()}}.
}
\section{Functions}{
\itemize{
\item \code{print(outlier_map)}: There is a S3 print method for class \code{"outlier_map"}.

}}
\examples{
dat <- example_data |> dplyr::filter(SampleType == "Sample")
om <- calcOutlierMap(dat)
class(om)

# S3 print method
om

# `sample.order = "frequency"` orders samples by outlier frequency
om <- calcOutlierMap(dat, sample.order = "frequency")
om$rows.by.freq
om$sample.order

# order samples field in Adat
om <- calcOutlierMap(dat, sample.order = "Sex")
om$sample.order
}
\seealso{
Other Calc Map: 
\code{\link{getOutlierIds}()},
\code{\link{plot.Map}()}
}
\author{
Stu Field
}
\concept{Calc Map}
