#'  Soil CO2 efflux from an incubation experiment, along with the soil mass and carbon concentration measurements.
#' 
#' @docType data
#' @description
#' A dataset with soil CO2 efflux measurements from a laboratory incubation at controlled temperature and moisture conditions.
#' 
#' @usage data(incubation_experiment)
#' @format
#' A list with 3 variables.
#'   \describe{
#'       \item{\code{eCO2}}{A data.frame with the flux data.}
#'       \item{\code{c_concentrations}}{a vector with 3 measurement of the concentration of carbon in the soil.}
#'       \item{\code{soil_mass}}{the mass of the soil column in g}
#'   }
#' 
#' @details
#'   The data.frame incubation_experiment$eCO2 has 3 columns.
#'     \describe{
#'       \item{\code{Days}}{A numeric vector with the day of measurement after the experiment started.}
#'       \item{\code{eCO2mean}}{A numeric vector with the release flux of CO2. Units in ug C g-1 soil day-1.}
#'       \item{\code{eCO2sd}}{A numeric vector with the standard deviation of the release flux of CO2-C. Units in ug C g-1 soil day-1.}
#'     }
#' A laboratory incubation experiment was performed in March 2014 for a period of 35 days under controlled conditions of temperature (15 degrees Celsius), moisture (30 percent soil water content), and oxygen levels (20 percent). Soil CO2 measurements were taken using an automated system for gas sampling connected to an infrared gas analyzer. The soil was sampled at a boreal forest site (Caribou Poker Research Watershed, Alaska, USA). This dataset presents the mean and standard deviation of 4 replicates.
#' 
#' @examples
#' eCO2=incubation_experiment$eCO2
#' head(eCO2)
#' 
#' plot(eCO2[,1:2],type="o",ylim=c(0,50),ylab="CO2 efflux (ug C g-1 soil day-1)")
#' arrows(eCO2[,1],eCO2[,2]-eCO2[,3],eCO2[,1],eCO2[,2]+eCO2[,3], angle=90,length=0.3,code=3)
#' 
#' @keywords datasets
'incubation_experiment'
