% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_plotQuilt.R
\name{plotQuilt}
\alias{plotQuilt}
\title{Plot \code{Quilt}}
\usage{
plotQuilt(
  slick,
  MP_label = "Code",
  OMs = NA,
  minmax = FALSE,
  shading = TRUE,
  kable = FALSE,
  signif = 3,
  alpha = 0.5
)
}
\arguments{
\item{slick}{A \code{\link[=Slick-class]{Slick-class()}} object}

\item{MP_label}{Label to use for the MPs. Either \code{Code} or \code{Label}.
\code{Description} works as well, but you probably don't want to do that.}

\item{OMs}{Integers representing the OMs to include in the plot. Defaults to all.}

\item{minmax}{Logical. Color shading from min to max values in each column?
If TRUE, ignores \code{MinValue(quilt)} and \code{MaxValue(quilt)}}

\item{shading}{Logical. Color shading for the columns?}

\item{kable}{Logical. Return a \code{kable} object?}

\item{signif}{Numeric Number of significant figures}

\item{alpha}{Numeric value. Transparency for color shading}
}
\value{
A \code{DT::datatable} or a \code{knitr::kable} object
}
\description{
Create a Quilt plot (unless \code{shading==FALSE} in which case it's just a table)
}
\details{
The columns are color shaded from light (lowest values) to dark (highest values).

Colors are set in \code{Color(quilt)}.

The color shading has 10 steps, from \code{MinValue(quilt)} to \code{MaxValue(quilt)} for each
Performance Indicator. If those values are missing (\code{NA}) for a given PI, colors
are shaded from lowest to highest values. If \code{minmax==TRUE}, \code{MinValue(quilt)} and \code{MaxValue(quilt)}
are ignored.
}
\examples{
# Generate dummy values
nOM <- 2
nMP <- 4
nPI <- 4

values <- array(NA, dim=c(nOM, nMP, nPI))

pi_means <- runif(nPI, 5, 50)
for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[om, mp, pi] <- rlnorm(1,log(pi_means[pi]), 0.4)
    }
  }
}

# Create and populate Object
quilt <- Quilt(Code=c('PI1', 'PI2', 'PI3', 'PI4'),
               Label=c('Performance Indicator 1',
                       'Performance Indicator 2',
                       'Performance Indicator 3',
                       'Performance Indicator 4'),
               Description = c('This is the description for PI 1',
                               'This is the description for PI 2',
                               'This is the description for PI 3',
                               'This is the description for PI 4'),
               Value=values)

# Check
Check(quilt)

# Add to `Slick` object
slick <- Slick()
Quilt(slick) <- quilt

# Plots
plotQuilt(slick)


# Alternative - include Simulation dimension

# Generate dummy values
nSim <- 3
nOM <- 2
nMP <- 4
nPI <- 4

values <- array(NA, dim=c(nSim, nOM, nMP, nPI))

pi_means <- runif(nPI, 5, 50)
for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[, om, mp, pi] <- rlnorm(nSim,log(pi_means[pi]), 0.4)
    }
  }
}

# Create and populate Object
quilt <- Quilt(Code=c('PI1', 'PI2', 'PI3', 'PI4'),
               Label=c('Performance Indicator 1',
                       'Performance Indicator 2',
                       'Performance Indicator 3',
                       'Performance Indicator 4'),
               Description = c('This is the description for PI 1',
                               'This is the description for PI 2',
                               'This is the description for PI 3',
                               'This is the description for PI 4'),
               Value=values)




# Add to `Slick` object
slick <- Slick()
Quilt(slick) <- quilt

# Plots
plotQuilt(slick)
apply(quilt@Value, 3:4, mean) |> round(1)


}
\seealso{
\code{\link[=Quilt]{Quilt()}}, \code{\link[=Quilt-class]{Quilt-class()}}
}
