% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_Quilt.R
\docType{class}
\name{Quilt-class}
\alias{Quilt-class}
\title{S4 class \code{Quilt}}
\description{
Objects of class \code{Quilt} are used to store information for the Quilt chart.
Like all S4 objects in \code{Slick}, slots in this object can be accessed and
assigned using functions corresponding to slot name. See \code{\link[=Quilt]{Quilt()}} and the
the \verb{See Also} section below.
}
\details{
Objects of class \code{Quilt} are created with \code{Quilt()}
\subsection{Multi-Language Support}{

Text with multi-language supported can be provided as a named list. Available languages:
\itemize{
\item \code{en}: English (default)
\item \code{es}: Spanish
\item \code{fr}: French
\item \code{pt}: Portuguese
}
}

\subsection{Note}{

Character strings in \code{Code}, \code{Label}, and \code{Description} must all be same length
as the number of performance indicators (\code{nPIs}) in \code{Value}
}
}
\section{Slots}{

\describe{
\item{\code{Code}}{A \emph{short} code for the Performance Indicators for this object.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Label}}{A short label for the Performance Indicators for this object. Used to label axes on charts.
Can be longer than \code{Code} but recommended to keep short as possible so it shows clearly in plots and tables.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Description}}{A description for the Performance Indicators for this object.
Can include Markdown, see \code{Examples}.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Value}}{A numeric array with the stochastic performance indicator values for each
operating model (OM), management procedure (MP), and performance indicator (PI).
Dimensions: c(\code{nOM}, \code{nMP}, and \code{nPI}). Alternatively, to calculate average over both
simulations and Operating Models, \code{Value} can be a 4-dimensional array with dimensions:
c(\code{nSim}, \code{nOM}, \code{nMP}, and \code{nPI}).}

\item{\code{Preset}}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.}

\item{\code{Color}}{A character vector length 2 of colors for the maximum and minimum
values in the chart.}

\item{\code{MinValue}}{Numeric vector length \code{nPI} with the minimum possible value for the
respective PIs. Defaults to minimum PI value in \code{Value} (averaged across OMs in some cases)}

\item{\code{MaxValue}}{Numeric vector length \code{nPI} with the maximum possible value (i.e., best performance)
for the respective PIs. Defaults to maximum PI value in \code{Value} (averaged across OMs in some cases).}

\item{\code{Misc}}{A named list for additional miscellaneous information.}
}}

\examples{
# Generate dummy values
nOM <- 2
nMP <- 4
nPI <- 4

values <- array(NA, dim=c(nOM, nMP, nPI))

pi_means <- runif(nPI, 5, 50)
for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[om, mp, pi] <- rlnorm(1,log(pi_means[pi]), 0.4)
    }
  }
}

# Create and populate Object
quilt <- Quilt(Code=c('PI1', 'PI2', 'PI3', 'PI4'),
               Label=c('Performance Indicator 1',
                       'Performance Indicator 2',
                       'Performance Indicator 3',
                       'Performance Indicator 4'),
               Description = c('This is the description for PI 1',
                               'This is the description for PI 2',
                               'This is the description for PI 3',
                               'This is the description for PI 4'),
               Value=values)

# Check
Check(quilt)

# Add to `Slick` object
slick <- Slick()
Quilt(slick) <- quilt

# Plots
plotQuilt(slick)


# Alternative - include Simulation dimension

# Generate dummy values
nSim <- 3
nOM <- 2
nMP <- 4
nPI <- 4

values <- array(NA, dim=c(nSim, nOM, nMP, nPI))

pi_means <- runif(nPI, 5, 50)
for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[, om, mp, pi] <- rlnorm(nSim,log(pi_means[pi]), 0.4)
    }
  }
}

# Create and populate Object
quilt <- Quilt(Code=c('PI1', 'PI2', 'PI3', 'PI4'),
               Label=c('Performance Indicator 1',
                       'Performance Indicator 2',
                       'Performance Indicator 3',
                       'Performance Indicator 4'),
               Description = c('This is the description for PI 1',
                               'This is the description for PI 2',
                               'This is the description for PI 3',
                               'This is the description for PI 4'),
               Value=values)




# Add to `Slick` object
slick <- Slick()
Quilt(slick) <- quilt

# Plots
plotQuilt(slick)
apply(quilt@Value, 3:4, mean) |> round(1)


}
\seealso{
\code{\link[=Quilt]{Quilt()}}, \code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}},
\code{\link[=Value]{Value()}}, \code{\link[=Preset]{Preset()}}
}
