% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_generics.R, R/class_Kobe.R, R/class_Slick.R
\docType{methods}
\name{Kobe}
\alias{Kobe}
\alias{Kobe<-}
\alias{Kobe,missing-method}
\alias{Kobe,character-method}
\alias{Kobe,list-method}
\alias{Kobe,Slick-method}
\alias{Kobe<-,Slick-method}
\title{Methods for Creating, Accessing and Assigning \code{Kobe} objects}
\usage{
Kobe(
  Code = "",
  Label = "",
  Description = "",
  Time = numeric(),
  TimeLab = "Year",
  Value = array(),
  Preset = list(),
  Target = 1,
  Limit = NULL,
  Defaults = list(),
  TimeTerminal = numeric(),
  Misc = list()
)

Kobe(Slick) <- value

\S4method{Kobe}{missing}()

\S4method{Kobe}{character}(
  Code = "",
  Label = "",
  Description = "",
  Time = numeric(),
  TimeLab = "Year",
  Value = array(),
  Preset = list(),
  Target = 1,
  Limit = NULL,
  Defaults = list(),
  TimeTerminal = numeric(),
  Misc = list()
)

\S4method{Kobe}{list}(
  Code = "",
  Label = "",
  Description = "",
  Time = numeric(),
  TimeLab = "Year",
  Value = array(),
  Preset = list(),
  Target = 1,
  Limit = NULL,
  Defaults = list(),
  TimeTerminal = numeric(),
  Misc = list()
)

\S4method{Kobe}{Slick}(Code)

\S4method{Kobe}{Slick}(Slick) <- value
}
\arguments{
\item{Code}{A \emph{short} code for the Performance Indicators for this object.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Label}{A short label for the Performance Indicators for this object. Used to label axes on charts.
Can be longer than \code{Code} but recommended to keep short as possible so it shows clearly in plots and tables.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Description}{A description for the Performance Indicators for this object.
Can include Markdown, see \code{Examples}.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Time}{A numeric vector with values for the projection time-steps. Must
match length \code{nTS} in \code{Value}}

\item{TimeLab}{Character string length 1. Name of the time step (e.g., 'Year'). Will be used as the label in the \verb{Kobe Time} plot. Use a named list for
multiple languages.}

\item{Value}{A numeric array with the stochastic performance indicator values for each
simulation (sim), operating model (OM), management procedure (MP), performance indicator (PI),
and projection time-steps (nTS).
Dimensions: c(\code{nsim}, \code{nOM}, \code{nMP}, \code{nPI}, \code{nTS})}

\item{Preset}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.}

\item{Target}{Numeric vector length \code{nPI} with the target value for the PIs. Defines the color quadrants on the Kobe plot. Defaults to c(1,1).}

\item{Limit}{Numeric vector length \code{nPI} with the limit value for the PIs. Shows as red line on Kobe plot. NULL to ignore.}

\item{Defaults}{A list object with default selections for the Kobe See \code{\link[=Kobe]{Kobe()}}}

\item{TimeTerminal}{Optional. By default the \code{Kobe} plot shows the terminal projection year.
\code{TimeTerminal} can be used to override this. Use a numeric value indicating the time (must match a value in \code{Time}) to use
for the \code{Kobe} plot}

\item{Misc}{A named list for additional miscellaneous information.}

\item{Slick}{A \code{\link[=Slick-class]{Slick-class()}} object}

\item{value}{A \code{\link[=Kobe-class]{Kobe-class()}} object}
}
\description{
The \code{Kobe} function is used both to create and modify an \code{\link[=Kobe-class]{Kobe-class()}} object.
and to access and assign \code{Kobe} for an object of class \code{\link[=Slick-class]{Slick-class()}}.
See \code{Details}.
}
\details{
Objects of class \code{Kobe} are created with \code{Kobe()}

The Kobe plot typically shows B/BMSY (or something similar) on the x-axis, and
F/FMSY (or something similar) on the y-axis.
\subsection{Performance Indicators}{

The first PI will be on the x-axis (usually B/BMSY or something similar) and the second
on the y-axis (e.g., F/FMSY)
}

\subsection{Multi-Language Support}{

Text with multi-language supported can be provided as a named list. Available languages:
\itemize{
\item \code{en}: English (default)
\item \code{es}: Spanish
\item \code{fr}: French
\item \code{pt}: Portuguese
}
}

\subsection{Note}{

Character strings in \code{Code}, \code{Label}, and \code{Description} must all be same length
as the number of performance indicators (\code{nPIs}) in \code{Value}
}
}
\section{Functions}{
\itemize{
\item \code{Kobe(missing)}: Create an empty \code{Kobe} object

\item \code{Kobe(character)}: Create a populated \code{Kobe} object

\item \code{Kobe(list)}: Create a populated \code{Kobe} object

\item \code{Kobe(Slick)}: Return \code{Kobe} from a \code{\link[=Slick-class]{Slick-class()}} object

\item \code{Kobe(Slick) <- value}: Assign a \code{\link[=Kobe-class]{Kobe-class()}} object to a \code{\link[=Slick-class]{Slick-class()}} object

}}
\examples{
# Generate dummy values
nsim <- 10
nOM <- 2
nMP <- 4
nPI <- 2
nTS <- 30

values <- array(NA, dim=c(nsim, nOM, nMP, nPI, nTS))

pi_means <- c(1,1)

for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[,om, mp, pi,] <- pi_means[pi] *
        matrix(
        cumprod(c(rlnorm(nTS*nsim, 0, 0.05))),
        nrow=nsim)
    }
  }
}

# Create and populate Object
kobe <- Kobe(Code=c('B/BMSY', 'F/FMSY'),
             Label=c('B/BMSY',
                     'F/FMSY'),
             Description = c('This is the description for PI 1',
                             'This is the description for PI 2'),
             Value=values
)

# Add values for projection time steps
Time(kobe) <- seq(2025, by=1, length.out=nTS)

# Check
Check(kobe)

# Add to `Slick` object
slick <- Slick()
Kobe(slick) <- kobe

# Plots
plotKobe(slick)

plotKobe(slick, Time=TRUE)

}
\seealso{
\code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}}, \code{\link[=Time]{Time()}}, [TimeLab(), \code{\link[=Value]{Value()}}, \code{\link[=Preset]{Preset()}},
\code{\link[=Target]{Target()}} and \code{\link[=Limit]{Limit()}}
}
