% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_Slick_old.R
\name{NewSlick}
\alias{NewSlick}
\title{Creates a blank Slick object}
\usage{
NewSlick(
  name = "Unnamed Slick Object",
  nPerf = list(nD = 5, nS = 6, nP = 7),
  nMPs = 5,
  nsim = 10,
  nProjYr = 50,
  nStateVar = 2,
  nHistYr = 55,
  Design = expand.grid(1:2, 1:2)
)
}
\arguments{
\item{name}{Character string that is the object name (shortened for use in menus etc.)}

\item{nPerf}{An integer vector of the number of deterministic (nD), stochastic (nS) and projected (nP) performance metrics}

\item{nMPs}{Integer, the number of management options (aka management procedures).}

\item{nsim}{Integer, the number of simulations (stochastic replicates per state of nature)}

\item{nProjYr}{Integer, the number of projected years}

\item{nStateVar}{Integer, the number of state variables}

\item{nHistYr}{Integer, the number of historical years for state variables}

\item{Design}{A design matrix of factor levels \verb{SN, factor}}
}
\value{
An object of class \linkS4class{Slick}
}
\description{
Creates a blank Slick object
}
\author{
T. Carruthers
}
