% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimTimeVar.R
\name{make_one_dataset}
\alias{make_one_dataset}
\title{Simulate time-varying covariates}
\usage{
make_one_dataset(n, obs, n.TBins, pcor, wcor, parameters, cat.parameters)
}
\arguments{
\item{n}{The number of clusters.}

\item{obs}{The number of observations per cluster.}

\item{n.TBins}{Number of time-varying binary variables.}

\item{pcor}{The across-subject correlation matrix. See Details.}

\item{wcor}{The within-subject correlation matrix. See Details.}

\item{parameters}{A dataframe containing the general simulation parameters. See Details.}

\item{cat.parameters}{A dataframe containing parameters for the categorical variables. See Details.}
}
\description{
Simulates a dataset with correlated time-varying covariates with an exchangeable correlation
structure. Covariates can be normal or binary
and can be static within a cluster or time-varying. Time-varying normal variables can optionally 
have linear trajectories within each cluster.
}
\details{
\strong{SPECIFYING THE PARAMETERS MATRIX}

The matrix \code{parameters} contains parameters required to generate all non-categorical variables.
It must contain column names \code{name, type, across.mean, across.SD, across.var, within.var, prop},
and \code{error.SD}. (To see an example, use \code{data(params)}.) Each variable to be generated requires
either one or two rows in \code{parameters}, depending on the variable type. 

The possible variable types and their corresponding specifications are:
\itemize{
 \item \strong{Static binary variables} do not change over time within a cluster. For example, if clusters
 are subjects, sex would be a static binary variable. Generating such a variable requires a single row
 of type \code{static.binary} with \code{prop} corresponding to the proportion of clusters for which the
 variable equals 1 and all other columns set to \code{NA}. (The correct standard deviation will automatically
 be computed later.) For example, if the variable is an indicator for a subject's being male, then \code{prop}
 specifies the proportion of males to be generated. 
 
 \item \strong{Time-varying binary variables} can change within a cluster over time, as for
 an indicator for whether a subject is currently taking the study drug. These variables require two rows in
 \code{parameters}. The first row should be of type \code{static.binary} with \code{prop} representing 
 the proportion of clusters for which the time-varying binary variable is 1 at least once
 (and all other columns set to \code{NA}). For example, this row in \code{parameters} could represent the
 proportion of subjects who ever take the study drug ("ever-users").
 
 The second row should be of type \code{subject.prop} with \code{across.mean} representing, for clusters
 that ever have a 1 for the binary variable, the proportion of observations within the cluster for which
 the variable is equal to 1. (All other columns should be set to \code{NA}.) For example, this this row in
 \code{parameters} could 
 represent the proportion of observations for which an ever-user is currently taking the drug. To indicate
 which pair of variables go together, the \code{subject.prop} should have the same name as the \code{static.binary}
 variable, but with the suffix \code{_s} appended (for example, the former could be named \code{drug_s} and
 the latter \code{drug}).
 
 \item \strong{Normal variables} are normally distributed within a cluster such that the within-cluster
 means are themselves also normally distributed in the population of clusters. Generating a normal variable requires
 specification of the population mean (\code{across.mean}) and standard deviation (\code{across.SD}) as well as of
 the within-cluster standard deviation (\code{within.SD}). To generate a static continuous variable, simply set
 \code{within.SD} to be extremely small (e.g., $1 * 10^{-7}$) and all corresponding correlations in matrix
 \code{wcor} to 0. 
 
 \item \strong{Time-function variables} are linear functions of time (with normal error) within each cluster such 
 that the within-cluster baseline values are normally distributed in the population of clusters. Generating a
 time-function variable requires two entries. The first entry should be of type \code{time.function} and
 specifies the population mean (\code{across.mean}) and standard deviation (\code{across.SD}) of the within-cluster
 baseline values as well as the error standard deviation (\code{error.SD}). The second entry should be of
 type \code{normal} and should have the same name as the \code{time.function} entry, but with the "_s" suffix.
 This entry specifies the mean (\code{across.mean}) and standard deviation (\code{across.SD}) of the within-cluster
 slopes. 
}

\strong{SPECIFYING THE CATEGORICAL PARAMETERS MATRIX}

The matrix \code{cat.parameters} contains parameters required to generate the single categorical variable, 
if any.
It must contain column names \code{level, parameter},
and \code{beta}. (To see an example, use \code{data(cat.params)}.)

\itemize{
 \item \strong{The reference level:} Each categorical variable must have exactly one "reference" level. The reference level should have one
row in \code{cat.parameters} for which \code{parameters} is set to \code{NA} and \code{beta} is set
to \code{ref}. For example, in the example file \code{cat.params} specifying parameters to generate a
subject's race, the reference level is \code{white}. 
 
 \item \strong{ Other levels: } Other levels of the categorical variable will have one or more rows. One row with parameter set to \code{intercept}
and \code{beta} set to a numeric value
represents the intercept term in the corresponding multinomial model. Any subsequent rows, with parameters set to 
names of other variables in the dataset and \code{beta} set to numeric values, 
represents other coefficients in the corresponding multinomial models. 
}

\strong{SPECIFYING THE POPULATION CORRELATION MATRIX}

Matrix \code{pcor} specifies the population (i.e., across-cluster) correlation matrix. It should have the same
number of rows and columns as \code{parameters} as well as the same variable names and ordering of variables.  

\strong{SPECIFYING THE WITHIN-CLUSTER CORRELATION MATRIX}

Matrix \code{wcor} specifies the within-cluster correlation matrix. The order of the variables listed in this file should be
consistent with the order in \code{params} and \code{pcor}. However, \code{static.binary} and \code{subject.prop} variables
should not be included in \code{wcor} since they are static within a cluster. Static continuous variables should be included,
but all the correlations should be set to zero.
}
\examples{
data = make_one_dataset(n=10, obs=10, n.TBins=2, pcor=pcor, wcor=wcor, 
parameters=complete_parameters(params, n=10), cat.parameters=cat.params)$data
}
