% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estsh.R
\name{est.shcoa.prime}
\alias{est.shcoa.prime}
\title{Estimating the Shapley value based on component orthogonal array (COA) with a prime d}
\usage{
est.shcoa.prime(d, n, val, ...)
}
\arguments{
\item{d}{a prime, the number of players.}

\item{n}{an integer, the sample size.}

\item{val}{the predefined value function.}

\item{...}{other parameters used in val(sets,...).}
}
\value{
a vector including estimated Shapley values of all players based on COA.
}
\description{
Estimating the Shapley value based on component orthogonal array (COA) with a prime d
}
\examples{
temp_adjacent<-matrix(0,nrow=5,ncol=5)
temp_adjacent[1,c(2,3,5)]<-1;temp_adjacent[2,4]<-1;temp_adjacent[3,5]<-1;
temp_adjacent<-temp_adjacent+t(temp_adjacent)
temp_val<-function(sets,adjacent){
  if(length(sets)==1) val<-0
  else{
    subadjacent<-adjacent[sets,sets]
    nsets<-length(sets)
    A<-diag(1,nsets); B<-matrix(0,nsets,nsets)
    for(l in 1:(nsets-1)){
      A<-A\%*\%subadjacent
      B<-B+A
    }
    val<-ifelse(sum(B==0)>nsets,0,1)
  }
  return(val)
}
est.shcoa.prime(5,20,temp_val,temp_adjacent)
}
