% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estsh.R
\name{est.shcoa}
\alias{est.shcoa}
\title{Estimating the Shapley value based on component orthogonal array (COA) with a prime power d}
\usage{
est.shcoa(d, n, val, p, f_d, ...)
}
\arguments{
\item{d}{a power of prime p, the number of players.}

\item{n}{an integer, the sample size.}

\item{val}{the predefined value function.}

\item{p}{a prime, the bottom number of d.}

\item{f_d}{a vector represents the coefficients of primative polynomial on GF(d). For example the primative polynomial on GF(3^2) is x^2+x+2, then let f_d=c(1,1,2).}

\item{...}{other parameters used in val(sets,...).}
}
\value{
a vector including estimated Shapley values of all players based on COA.
}
\description{
Estimating the Shapley value based on component orthogonal array (COA) with a prime power d
}
\examples{
temp_adjacent<-matrix(0,nrow=8,ncol=8)
temp_adjacent[1,6:8]<-1;temp_adjacent[2,7]<-1;temp_adjacent[c(4,6,7),8]<-1;
temp_adjacent<-temp_adjacent+t(temp_adjacent)
temp_val<-function(sets,adjacent){
  if(length(sets)==1) val<-0
  else{
    subadjacent<-adjacent[sets,sets]
    nsets<-length(sets)
    A<-diag(1,nsets); B<-matrix(0,nsets,nsets)
    for(l in 1:(nsets-1)){
      A<-A\%*\%subadjacent
      B<-B+A
    }
    val<-ifelse(sum(B==0)>nsets,0,1)
  }
  return(val)
}
est.shcoa(8,112,temp_val,2,c(1,0,1,1),temp_adjacent)
}
