\name{SeedImbibition}
\alias{seed_imbib}
\title{Seed Imbibition Percentage}
\usage{
seed_imbib(wt_of_seed_after_imbib, initial_wt_of_seed)
}
\arguments{
\item{wt_of_seed_after_imbib}{Weight of seeds after imbibition}
\item{initial_wt_of_seed}{Initial weight of seeds}
}
\value{
Seed Imbibition Percentage
}
\description{
Imbibition causes seeds to expand, which results in the seed coat or testa being broken. Seed germination begins with imbibition. Imbibition aids in the transport of water into the developing ovules. Imbibition is required during the first stages of root water absorption. Imbibition percentage of seeds was calculated using the following formula (Govender et al., 2008) <doi:10.1016/j.sajb.2007.10.006>
}
\examples{
wt_of_seed_after_imbib <- 2.5
initial_wt_of_seed <- 1.7
seed_imbib(wt_of_seed_after_imbib, initial_wt_of_seed)
}
\references{
Govender, V., Aveling, T.A.S., Kritzinger, Q., 2008. The effect of traditional storage methods on germination and vigour of maize (Zea mays L.) from northern KwaZulu-Natal and southern Mozambique. S. Afr. J. Bot. 74, 190–196.\\
Dutta, S. K., Layek, J., Akoijam, R. S., Boopathi, T., Vanlalhmangaiha, Saha, S., & Prakash, N. (2019). Seaweed extract as natural priming agent for augmenting seed quality traits and yield in Capsicum frutescens L. Journal of applied phycology, 31, 3803-3813.
}
\keyword{Seed Imbibition Percentage}
