% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{ver_map}
\alias{ver_map}
\title{Plot a verification map of percentiles}
\usage{
ver_map(
  dt,
  o = obs_cols(dt),
  yy = dt[, max(year)],
  climatology_period = unique(dt[, year]),
  out_file = NULL
)
}
\arguments{
\item{dt}{input data table. This has to contain the observations for the year to plot, as well as for many other years (which are used to calculate the climatological reference).
The data table should have coumns named \code{lon}, \code{lat}, \code{year}, and an observation column, the name of which is passed as value of \code{o} to the function, see below.
For each level of \code{lon}, \code{lat}, and \code{year}, the table should only contain one row (this is checked by the function).}

\item{o}{name of the column containing the observation.}

\item{yy}{The year for which to show the verification map. Defaults to the last year available in dt}

\item{climatology_period}{which years should the climatology be calculated on? Defaults to all years (except \code{yy}) in \code{dt}}

\item{out_file}{optional path and file name (including valid filetype, like .pdf or .png) for saving the file. If not provided, the function just shows the plot in the running R session.}
}
\value{
a gg object
}
\description{
For each location, the map shows whether the observed value was normal, below, or above. This makes it possible to visually compare to the usual tercile forecsst
}
\examples{
\donttest{
# takes some time:
pp = ver_map(chirps_monthly[month == 11],yy = 2018)
if(interactive()) plot(pp)
}
}
