% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{summary.SeaSondeRAPM}
\alias{summary.SeaSondeRAPM}
\title{Summarizes a SeaSondeRAPM Object}
\usage{
\method{summary}{SeaSondeRAPM}(object, ...)
}
\arguments{
\item{object}{An object of class "SeaSondeRAPM". This object should be created using
the seasonder_createSeaSondeRAPM() function and must include a calibration matrix, a quality matrix,
the BEAR attribute, and a StationCode.}

\item{...}{Additional arguments that might be passed to other methods; currently not used.}
}
\value{
Invisibly returns the input SeaSondeRAPM object. This allows the function to be used in a sequence
of operations (e.g., chaining) without printing the object again after the summary is displayed.
}
\description{
This function prints a summary of a SeaSondeRAPM object by displaying its processing steps.
The processing steps provide a record of the transformations and operations applied to the object,
which can be useful for debugging and understanding the data workflow.
}
\details{
The function first verifies that the provided object inherits from the "SeaSondeRAPM" class.
It then retrieves the processing steps associated with the object via the seasonder_getSeaSondeRAPM_ProcessingSteps()
function. These steps are concatenated into a single string, which is printed alongside a header indicating that
they represent the processing steps. This method is primarily used for diagnostic purposes and for verifying
that the object has undergone the intended series of operations.
}
\examples{
# Summarize a test SeaSondeRAPM object
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
obj <- seasonder_readSeaSondeRAPMFile(apm_file)
summary(obj)
}
