% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_setSeaSondeRCS_MUSIC_doppler_interpolation}
\alias{seasonder_setSeaSondeRCS_MUSIC_doppler_interpolation}
\alias{seasonder_setMUSICDopplerInterpolation}
\title{Set the Doppler Interpolation Factor in a SeaSondeRCS Object}
\usage{
seasonder_setSeaSondeRCS_MUSIC_doppler_interpolation(
  seasonder_cs_object,
  doppler_interpolation
)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing radar data and metadata.}

\item{doppler_interpolation}{An integer specifying the Doppler interpolation factor. Must be 1, 2, 3, or 4.}
}
\value{
The SeaSondeRCS object with the updated Doppler interpolation option.
}
\description{
This function validates and assigns the Doppler interpolation factor in the SeaSondeRCS object, updating the corresponding option in the \code{MUSIC_data} field.
}
\details{
The function performs the following operations:
\enumerate{
\item Validates the value of \code{doppler_interpolation} using the function \code{SeaSondeRCS_MUSIC_validate_doppler_interpolation}.
\item Updates the attribute \code{MUSIC_options$doppler_interpolation} of the SeaSondeRCS object with the validated value.
}
}
\examples{
# Create a valid SeaSondeRCS object for examples
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_object <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
# Set the Doppler interpolation factor to 2 (internal alias)
cs_object <- seasonder_setSeaSondeRCS_MUSIC_doppler_interpolation(cs_object, 2)
}
\seealso{
\code{\link{SeaSondeRCS_MUSIC_validate_doppler_interpolation}} for Doppler interpolation factor validation.
}
