% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setSeaSondeRCS_FOR}
\alias{seasonder_setSeaSondeRCS_FOR}
\title{Set First Order Region Data in a SeaSondeRCS Object}
\usage{
seasonder_setSeaSondeRCS_FOR(seasonder_cs_object, FOR)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing spectral and metadata information.}

\item{FOR}{A data structure containing the First Order Region (FOR) data. This is typically a list
with elements such as \code{negative_FOR} and \code{positive_FOR} representing Doppler bin indices.}
}
\value{
The updated \code{SeaSondeRCS} object with the specified FOR data stored in its attributes.
}
\description{
This function assigns First Order Region (FOR) data to a SeaSondeRCS object.
The FOR data is stored within the object's attributes under the "FOR_data" element.
Currently, no explicit validation is performed on the provided FOR data.
}
\details{
This low-level setter function updates the SeaSondeRCS object by assigning the provided FOR data
to the "FOR" field within the object's "FOR_data" attribute. It is intended to be used internally
as part of the FOR processing workflow.
}
\examples{
# Set sample file paths
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
sample_FOR <- list(
  negative_FOR = c(1, 2, 3),
  positive_FOR = c(10, 11, 12)
)
cs_obj <- seasonder_setSeaSondeRCS_FOR(cs_obj, sample_FOR)
}
