% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_rejectNoiseIonosphericTest}
\alias{seasonder_rejectNoiseIonosphericTest}
\title{Reject Bragg Peaks Due to Noise/Ionospheric Contamination}
\usage{
seasonder_rejectNoiseIonosphericTest(
  seasonder_cs_object,
  peak,
  range = NA,
  peak_name = ""
)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing spectral data and FOR parameters.}

\item{peak}{A numeric vector indicating the Doppler bin positions of the peak under evaluation.}

\item{range}{Optional; A numeric or integer value representing the range cell corresponding to the peak.
Defaults to \code{NA}.}

\item{peak_name}{Optional; A character string representing the name or identifier of the peak
(e.g., \code{"positive_FOR"} or \code{"negative_FOR"}). Defaults to an empty string.}
}
\value{
A possibly modified version of the \code{peak} argument, where a rejected peak
is returned as \code{integer(0)}, indicating that it does not pass the noise/ionospheric test.
}
\description{
This function evaluates Bragg peaks based on the power ratio between the Bragg region
and the surrounding non-Bragg region. If the non-Bragg power exceeds the Bragg power
by a specified threshold, the peak is rejected.
}
\details{
\strong{Reason for the Test:}
This test ensures that Bragg peaks are not contaminated by excessive noise or ionospheric interference.
Bragg regions with significantly higher non-Bragg power levels are likely to be invalid and are rejected.

\strong{Steps:}
\enumerate{
\item \strong{Threshold Retrieval:}
\itemize{
\item Retrieves the \code{reject_noise_ionospheric_threshold} parameter, which defines the power difference (in dB)
allowed between the Bragg and non-Bragg regions.
}
\item \strong{Peak Region Determination:}
\itemize{
\item Determines whether the peak is in the positive or negative Bragg region based on its location relative to
the central Doppler bin.
}
\item \strong{Non-Bragg Region Extraction:}
\itemize{
\item Identifies the non-Bragg region by excluding the bins corresponding to the peak.
}
\item \strong{Power Calculations:}
\itemize{
\item Calculates the total power for the Bragg and non-Bragg regions and converts them to decibels (dB).
}
\item \strong{Rejection Criterion:}
\itemize{
\item If the non-Bragg power exceeds the Bragg power by more than the threshold, the peak is rejected.
\item Logs a message detailing the rejection.
}
}

\strong{Use Case:}
This function is particularly useful in environments where noise or ionospheric effects are prevalent,
ensuring that only valid first-order Bragg peaks are retained.
}
\seealso{
\itemize{
\item \code{\link{seasonder_rejectDistantBraggPeakTest}} for evaluating peaks based on proximity to Bragg indices.
\item \code{\link{seasonder_getSeaSondeRCS_FOR_SS_Smoothed}} for retrieving smoothed spectra.
\item \code{\link{seasonder_SelfSpectra2dB}} for power conversion to dB.
}
}
