% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCSSW.R
\name{seasonder_readSeaSondeRCSSWFile}
\alias{seasonder_readSeaSondeRCSSWFile}
\title{Read SeaSonde RCSSW File and Create SeaSondeRCS Object}
\usage{
seasonder_readSeaSondeRCSSWFile(
  filepath,
  specs_path = seasonder_defaultSpecsFilePath("CSSW"),
  endian = "big"
)
}
\arguments{
\item{filepath}{A character string specifying the path to the SeaSonde RCSSW file.}

\item{specs_path}{A character string specifying the path to the YAML file containing CSSW specifications.
Defaults to the output of \code{seasonder_defaultSpecsFilePath("CSSW")}.}

\item{endian}{A character string indicating the byte order used in the file. Defaults to \code{"big"}.}
}
\value{
A SeaSondeRCS object containing the parsed header and data.
}
\description{
This function reads a SeaSonde RCSSW file from a specified file path and parses its content
into a SeaSondeRCS object. The file is processed by reading its header and body sections using
CSSW specifications provided via a YAML file.
}
\details{
The function executes the following steps:
\enumerate{
\item Sets up error handling parameters specific to the function.
\item Retrieves YAML specifications for the key size block from the CSSW spec file.
\item Attempts to open the file in binary mode ("rb") with warnings suppressed.
\item Reads the file key and uses it to extract file specs.
\item Reads the header key, retrieves header specs, and parses the CSSW header.
\item Converts the CSSW header into a valid SeaSondeRCS header.
\item Reads the body key, retrieves body specs, and parses the CSSW body.
\item Transforms the CSSW body into a SeaSondeRCS data structure.
\item Combines the header and data into a SeaSondeRCS object.
}
}
