% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getnDopplerCells}
\alias{seasonder_getnDopplerCells}
\title{Get the nDopplerCells value from a SeaSondeRCS object}
\usage{
seasonder_getnDopplerCells(seasonder_obj)
}
\arguments{
\item{seasonder_obj}{A SeaSondeRCS object.}
}
\value{
The nDopplerCells value.
}
\description{
Get the nDopplerCells value from a SeaSondeRCS object
}
\examples{
# Minimal example for seasonder_getnDopplerCells
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
n_doppler_cells <- seasonder_getnDopplerCells(cs_obj)
print(n_doppler_cells)
}
