% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getSeaSondeRCS_reference_noise_normalized_limits_estimation_interval}
\alias{seasonder_getSeaSondeRCS_reference_noise_normalized_limits_estimation_interval}
\title{Retrieve the Reference Noise Normalized Limits Estimation Interval}
\usage{
seasonder_getSeaSondeRCS_reference_noise_normalized_limits_estimation_interval(
  seasonder_cs_object
)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object.}
}
\value{
The reference noise normalized limits estimation interval as stored in the object.
}
\description{
This function extracts the reference noise normalized limits estimation interval from a
SeaSondeRCS object's attributes. These limits are stored under the attribute name
\code{"reference_noise_normalized_limits_estimation_interval"}.
}
\details{
This interval is typically used during the noise level estimation process for the SeaSondeRCS object.
}
\examples{
# Create a minimal SeaSondeRCS object
cs_obj <- structure(list(data = list(a = 1, b = 2)), class = "SeaSondeRCS")
interval <- seasonder_getSeaSondeRCS_reference_noise_normalized_limits_estimation_interval(cs_obj)
print(interval)
}
