% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_getSeaSondeRCS_FORConfig}
\alias{seasonder_getSeaSondeRCS_FORConfig}
\title{Retrieve First Order Region (FOR) Configuration from a SeaSondeRCS Object}
\usage{
seasonder_getSeaSondeRCS_FORConfig(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing FOR-related metadata.}
}
\value{
A list with two components:
\itemize{
\item \code{FOR_parameters}: A list of parameters used for FOR processing.
\item \code{NoiseLevel}: The noise level values retrieved from the object.
}
}
\description{
This function extracts the configuration related to the First Order Region (FOR) from a SeaSondeRCS object.
It returns a list containing the FOR parameters and the noise level assigned to the object.
}
\details{
The FOR configuration is composed of parameters that define the first order region and the noise level used during
FOR processing. This function aggregates these components by calling \code{seasonder_getFOR_parameters()} and
\code{seasonder_getSeaSondeRCS_NoiseLevel()}.
}
\examples{
# Create a minimal SeaSondeRCS object
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
config <- seasonder_getSeaSondeRCS_FORConfig(cs_obj)
print(config)

}
