% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonder_specsHandling.R
\name{seasonder_find_spectra_file_type}
\alias{seasonder_find_spectra_file_type}
\title{Determine the Spectra File Type}
\usage{
seasonder_find_spectra_file_type(filepath, endian = "big")
}
\arguments{
\item{filepath}{A character string specifying the path to the spectra file.}

\item{endian}{A character string indicating the file's byte order ("big" by default).}
}
\value{
A character string representing the spectra file type ("CS" or "CSSY").
}
\description{
This function identifies the type of a spectra file (either "CS" or "CSSY") by reading its header block based on YAML specifications.
It first attempts to read a key size block using the CSSY specifications, and if that fails, it reopens the file and tries to read the CS header block.
}
\details{
The function sets up error handling parameters and uses YAML specifications retrieved via
\code{seasonder_readYAMLSpecs} and \code{seasonder_defaultSpecsFilePath}. It opens the file in binary read mode
and ensures the connection is closed upon exit. If reading the key size block fails, it reopens the file to try
reading the CS header block. The final file type is determined by the key returned from the file block.
}
