% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_findFORNullsInSSMatrix}
\alias{seasonder_findFORNullsInSSMatrix}
\title{Identify Nulls in First Order Region (FOR) for a Self-Spectra Matrix}
\usage{
seasonder_findFORNullsInSSMatrix(
  seasonder_cs_object,
  SS,
  doppler_bins,
  negative_Bragg_region = FALSE
)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing spectral data and FOR parameters.}

\item{SS}{A numeric matrix representing the self-spectra data, where rows correspond to range cells
and columns correspond to Doppler bins.}

\item{doppler_bins}{A numeric vector indicating the Doppler bins corresponding to the columns of \code{SS}.}

\item{negative_Bragg_region}{A logical value indicating whether to analyze the negative Bragg region. Default is \code{FALSE}.}
}
\value{
A named list where each entry corresponds to a range cell, containing the detected FOR null positions.
}
\description{
This function applies the null-finding algorithm to each row of a self-spectra (SS) matrix,
determining the boundaries of the First Order Region (FOR) for each range cell.
}
\details{
This function processes each row of the self-spectra matrix, treating each row as an independent spectrum
for which the FOR nulls are identified. The nulls define the boundaries of the first-order Bragg region.

\strong{Processing Steps:}
\enumerate{
\item Iterate through each row of the \code{SS} matrix.
\item Extract the power spectrum for the corresponding range cell.
\item Apply \code{\link{seasonder_findFORNullsInSpectrum}} to determine the null positions.
\item Store the results in a named list, where each entry corresponds to a range cell.
}
}
\seealso{
\itemize{
\item \code{\link{seasonder_findFORNullsInSpectrum}} for detecting nulls in a single spectrum.
\item \code{\link{seasonder_findFORNulls}} for high-level null detection across all spectra.
}
}
