% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_findFORNullsInFOR}
\alias{seasonder_findFORNullsInFOR}
\title{Find Nulls in First Order Region (FOR)}
\usage{
seasonder_findFORNullsInFOR(
  FOR,
  start_point_P,
  doppler_bins,
  left_region = FALSE
)
}
\arguments{
\item{FOR}{A numeric vector representing the power spectrum in the FOR region.}

\item{start_point_P}{A numeric value representing the power threshold at which the search for the null point begins.}

\item{doppler_bins}{A numeric vector containing the Doppler bins corresponding to the spectrum in \code{FOR}.}

\item{left_region}{A logical value indicating whether the null is being searched for in the negative Bragg region. Default is \code{FALSE}.}
}
\value{
A numeric value representing the Doppler bin at the detected null position.
}
\description{
This function locates the null point in the First Order Region (FOR) spectrum, which separates the first-order Bragg peak from second-order energy or the noise floor.
}
\details{
The function follows these steps to determine the null point:
\enumerate{
\item If \code{left_region} is \code{TRUE}, the FOR spectrum and Doppler bins are reversed.
\item The power spectrum is transformed to facilitate peak identification:
\itemize{
\item The absolute values of the power are taken and multiplied by -1.
\item The \code{start_point_P} threshold is also inverted.
}
\item The function identifies the first local maximum in the transformed spectrum that exceeds \code{start_point_P}.
\item The corresponding Doppler bin at the detected peak is returned as the null position.
}

The function relies on \code{pracma::findpeaks} to identify the peak.
}
\seealso{
\itemize{
\item \code{\link{seasonder_findFORNullsInSpectrum}} for locating nulls in a full spectrum.
\item \code{\link[pracma]{findpeaks}} for peak detection.
}
}
