% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_exportCTFRangeInfo}
\alias{seasonder_exportCTFRangeInfo}
\title{Export CTF Range Information to a File}
\usage{
seasonder_exportCTFRangeInfo(seasonder_cs_object, file, tableStart = "")
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing the relevant MUSIC processing data.}

\item{file}{A character string specifying the output file path where the range information will be written.}

\item{tableStart}{A character string to prepend to the table output. Defaults to an empty string.}
}
\value{
Invisibly returns a data frame containing the range information.
}
\description{
This function writes the formatted CTF range information, generated from a SeaSondeRCS object, to a specified file.
}
\details{
The function internally calls \code{seasonder_exportCTFRangeInfo_string} to obtain a formatted string of range information.
It then writes this output string to the specified file. Additionally, it returns the extracted range information
invisibly, allowing further processing if necessary.
}
\examples{
  # Prepare a SeaSondeRCS object with valid data
  apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
  apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
  cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
  cs_obj <- seasonder_createSeaSondeRCS(
    cs_file,
    seasonder_apm_object = apm_obj
  )
  # Export CTF range information to a temporary text file
  range_info <- seasonder_exportCTFRangeInfo(cs_obj, tempfile(fileext = ".txt"))

}
