% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_computeDopplerBinsFrequency}
\alias{seasonder_computeDopplerBinsFrequency}
\title{Compute Doppler Bins Frequencies}
\usage{
seasonder_computeDopplerBinsFrequency(
  seasonder_cs_object,
  nDoppler,
  center_bin,
  spectra_res,
  normalized = FALSE
)
}
\arguments{
\item{seasonder_cs_object}{A SeaSonde CS object created by \code{seasonder_createSeaSondeRCS()}.
This object contains the necessary metadata, such as Doppler resolution and
center bin, for frequency computation.}

\item{nDoppler}{Integer. The total number of Doppler bins.}

\item{center_bin}{Numeric. The index of the central Doppler bin corresponding to 0 Hz.}

\item{spectra_res}{Numeric. The spectral resolution in Hz for each Doppler bin.}

\item{normalized}{Logical. If \code{TRUE}, the frequencies are normalized by dividing
them by the positive Bragg frequency. Default is \code{FALSE}.}
}
\value{
A numeric vector representing the Doppler frequencies for each bin. If
\code{normalized = TRUE}, the values are dimensionless and relative to the
positive Bragg frequency. Otherwise, they are in Hz.
}
\description{
This function computes the Doppler frequencies associated with each Doppler bin
in a SeaSondeRCS object. The output can be normalized by the positive Bragg
frequency if specified.
}
\details{
Doppler frequencies are calculated using the formula:
\deqn{\text{frequency}_i = (\text{bin index}_i - \text{center bin}) \times \text{resolution}}
For normalized frequencies:
\deqn{\text{frequency}_i = \frac{\text{frequency}_i}{\text{positive Bragg frequency}}}

The center bin is typically determined using \code{seasonder_getCenterDopplerBin()},
and the resolution is obtained from \code{seasonder_getDopplerSpectrumResolution()}.
Normalization is based on the positive Bragg frequency calculated by
\code{seasonder_getBraggDopplerAngularFrequency()}.
}
\seealso{
\code{\link{seasonder_getCenterDopplerBin}},
\code{\link{seasonder_getDopplerSpectrumResolution}},
\code{\link{seasonder_getBraggDopplerAngularFrequency}}
}
