% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_asJSONSeaSondeRCSHeader}
\alias{seasonder_asJSONSeaSondeRCSHeader}
\title{Convert SeaSondeRCS Object to JSON}
\usage{
seasonder_asJSONSeaSondeRCSHeader(seasonder_cs_object, path = NULL)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object from which the header data will be extracted.}

\item{path}{Optional path to a file where the JSON output should be saved. If provided, the function will write the JSON data to this file. If NULL, the function will only return the JSON data as a string without writing it to a file.}
}
\value{
A character string in JSON format representing the header data of the provided SeaSondeRCS object. If a path is provided, the function also writes this data to the specified file.
}
\description{
This function extracts the header data from a \code{seasonder_cs_object}, representing a SeaSondeRCS object, and converts it into a JSON format. Optionally, it can write this JSON data to a specified file path.
}
\note{
If a path is provided and there is an issue writing to the file, the function logs an error message using \code{seasonder_logAndMessage} and returns the JSON data as a string.
}
\examples{
# Example: create a simple SeaSondeRCS object and convert its header to JSON
cs_obj <- structure(list(data = list(a = 1, b = 2)), class = "SeaSondeRCS")
attr(cs_obj, "header") <- list(
  nSiteCodeName = "Station1",
  nDateTime = Sys.time(),
  nDopplerCells = 2,
  nRangeCells = 3
)
json_header <- seasonder_asJSONSeaSondeRCSHeader(cs_obj)
print(json_header)
}
\seealso{
\code{\link{seasonder_createSeaSondeRCS}}, \code{\link{seasonder_getSeaSondeRCS_header}}
}
