% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_SmoothSS}
\alias{seasonder_SmoothSS}
\title{Smooth Self-Spectra Matrix Using a Sliding Window}
\usage{
seasonder_SmoothSS(seasonder_cs_object, antenna, smoothing = NULL)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing self-spectra data.}

\item{antenna}{A character or numeric identifier of the antenna whose self-spectra will be smoothed.}

\item{smoothing}{Optional. An integer specifying the number of Doppler bins used for smoothing.
If \code{NULL}, the function retrieves the default smoothing factor (\code{nsm}) from
\code{\link{seasonder_getFOR_parameters}}.}
}
\value{
A matrix with the same dimensions as the input self-spectra matrix, but with smoothed values.
}
\description{
This function applies a smoothing operation to the self-spectra (SS) matrix of a specific antenna
in a SeaSondeR cross-spectral object. The smoothing is performed using a sliding mean over a specified
number of Doppler bins.
}
\details{
The smoothing process is performed using a centered sliding mean filter with a window of \code{nsm} bins.
The window extends symmetrically before and after each bin, with adjustments based on whether \code{nsm}
is even or odd:
\itemize{
\item If \code{nsm} is even, the window includes \code{nsm/2} bins before and after the target bin.
\item If \code{nsm} is odd, the window includes \code{(nsm - 1)/2} bins before and \code{(nsm - 1)/2 + 1} bins after.
}

The function utilizes \code{\link[slider]{slide_mean}} to apply the smoothing operation row-wise
across the self-spectra matrix.

This smoothing implementation mimics the one performed by the tool AnalyzeSpectra of CODAR's Radial Suite R8.
}
\seealso{
\itemize{
\item \code{\link{seasonder_getFOR_parameters}} for retrieving default \code{nsm} values.
\item \code{\link{seasonder_getSeaSondeRCS_antenna_SSdata}} for accessing self-spectra data.
\item \code{\link[slider]{slide_mean}} for applying the sliding window mean operation.
}
}
