% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSIC_Bins2DopplerFreq}
\alias{seasonder_MUSIC_Bins2DopplerFreq}
\title{Map Doppler Bins to Doppler Frequencies}
\usage{
seasonder_MUSIC_Bins2DopplerFreq(seasonder_cs_object, bins)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object representing the cross-spectral data structure.
It contains metadata and configuration for Doppler frequency and bin mapping.}

\item{bins}{A numeric or integer vector of bin indices for which Doppler frequencies are needed.}
}
\value{
A numeric vector of Doppler frequencies corresponding to the input bin indices.
}
\description{
This function retrieves the Doppler frequencies corresponding to specified Doppler bins
for a given SeaSonde cross-spectral object.
}
\details{
The function retrieves the full set of unnormalized Doppler bin frequencies using
\code{\link{seasonder_getSeaSondeRCS_MUSIC_DopplerBinsFrequency}} and returns the frequencies
corresponding to the provided bin indices. This is useful for translating bin-domain indices
into physical Doppler frequency values for analysis or visualization.
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_MUSIC_DopplerBinsFrequency}}
}
