% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICComputeSignalPowerMatrix}
\alias{seasonder_MUSICComputeSignalPowerMatrix}
\title{Compute Signal Power Matrix for MUSIC Algorithm}
\usage{
seasonder_MUSICComputeSignalPowerMatrix(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC data, including eigenvalues, eigenvectors,
and DOA solutions.}
}
\value{
The updated SeaSondeRCS object with the MUSIC data containing the computed power matrices for
both dual and single solutions.
}
\description{
This function computes the signal power matrix for each direction of arrival (DOA) solution obtained
from the MUSIC algorithm. It updates the MUSIC data in the provided SeaSondeRCS object with the computed
power matrices.
}
\details{
The function performs the following steps:
\enumerate{
\item Retrieves the MUSIC data from the SeaSondeRCS object.
\item Defines an internal function to update the DOA solutions with computed power matrices:
\itemize{
\item For dual steering vectors (\code{DOA_sol$dual$a}), computes the power matrix using
\code{seasonder_computePowerMatrix} and updates \code{DOA_sol$dual$P}.
\item For single steering vectors (\code{DOA_sol$single$a}), computes the power matrix using
\code{seasonder_computePowerMatrix} and updates \code{DOA_sol$single$P}.
}
\item Iterates through the MUSIC data, applying the update function to each set of eigenvalues and DOA solutions.
\item Updates the SeaSondeRCS object with the modified MUSIC data.
}
}
\seealso{
\code{\link{seasonder_computePowerMatrix}}
}
