# SVG 1.0.0

## First Release

### New Features

* **Unified interface**: `CalSVG()` function provides a single entry point for all SVG detection methods
* **Six SVG detection methods** implemented with consistent output format:
  - `CalSVG_MERINGUE()`: Moran's I with binary spatial network
  - `CalSVG_Seurat()`: Moran's I with inverse distance weights  
  - `CalSVG_binSpect()`: Binary spatial enrichment test (Giotto)
  - `CalSVG_SPARKX()`: Non-parametric kernel-based test
  - `CalSVG_nnSVG()`: Nearest-neighbor Gaussian processes
  - `CalSVG_MarkVario()`: Mark variogram method

### Spatial Network Construction

* `buildSpatialNetwork()`: Build spatial neighborhood networks using Delaunay triangulation or KNN
* `getSpatialNeighbors_Delaunay()`: Delaunay triangulation-based network
* `getSpatialNeighbors_KNN()`: K-nearest neighbors network

### Statistical Utilities

* `moranI()`: Calculate Moran's I statistic
* `moranI_test()`: Hypothesis testing for spatial autocorrelation
* `ACAT_combine()`: Aggregated Cauchy Association Test for p-value combination
* `binarize_expression()`: Multiple methods for expression binarization

### Data Simulation

* `simulate_spatial_data()`: Generate simulated spatial transcriptomics data with known SVGs
* Support for multiple spatial patterns: gradient, hotspot, periodic, cluster

### Performance

* C++ implementation via Rcpp/RcppArmadillo for computationally intensive operations
* Parallel processing support via `n_threads` parameter
* Efficient memory usage for large-scale data

### Documentation

* Comprehensive vignette with mathematical background
* Complete function documentation with examples
* Benchmark comparison between methods

### Dependencies

* Core: Matrix, Rcpp, RcppArmadillo
* Optional: geometry, RANN, BRISC, CompQuadForm, BiocParallel, spatstat

## Authors

* Zaoqu Liu (maintainer) - liuzaoqu@163.com
