% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-quantile-functions.R
\name{estimate_functions_quantile}
\alias{estimate_functions_quantile}
\alias{estimate_k_quantile}
\alias{estimate_k_generic_1RM_quantile}
\alias{estimate_k_1RM_quantile}
\alias{estimate_kmod_quantile}
\alias{estimate_kmod_1RM_quantile}
\alias{estimate_klin_quantile}
\alias{estimate_klin_1RM_quantile}
\title{Estimate relationship between reps and weight using the non-linear quantile regression}
\usage{
estimate_k_quantile(
  perc_1RM,
  reps,
  eRIR = 0,
  tau = 0.5,
  reverse = FALSE,
  control = quantreg::nlrq.control(maxiter = 10^4, InitialStepSize = 0),
  ...
)

estimate_k_generic_1RM_quantile(
  weight,
  reps,
  eRIR = 0,
  k = 0.0333,
  tau = 0.5,
  reverse = FALSE,
  control = quantreg::nlrq.control(maxiter = 10^4, InitialStepSize = 0),
  ...
)

estimate_k_1RM_quantile(
  weight,
  reps,
  eRIR = 0,
  tau = 0.5,
  reverse = FALSE,
  control = quantreg::nlrq.control(maxiter = 10^4, InitialStepSize = 0),
  ...
)

estimate_kmod_quantile(
  perc_1RM,
  reps,
  eRIR = 0,
  tau = 0.5,
  reverse = FALSE,
  control = quantreg::nlrq.control(maxiter = 10^4, InitialStepSize = 0),
  ...
)

estimate_kmod_1RM_quantile(
  weight,
  reps,
  eRIR = 0,
  tau = 0.5,
  reverse = FALSE,
  control = quantreg::nlrq.control(maxiter = 10^4, InitialStepSize = 0),
  ...
)

estimate_klin_quantile(
  perc_1RM,
  reps,
  eRIR = 0,
  tau = 0.5,
  reverse = FALSE,
  control = quantreg::nlrq.control(maxiter = 10^4, InitialStepSize = 0),
  ...
)

estimate_klin_1RM_quantile(
  weight,
  reps,
  eRIR = 0,
  tau = 0.5,
  reverse = FALSE,
  control = quantreg::nlrq.control(maxiter = 10^4, InitialStepSize = 0),
  ...
)
}
\arguments{
\item{perc_1RM}{\%1RM}

\item{reps}{Number of repetitions done}

\item{eRIR}{Subjective estimation of reps-in-reserve (eRIR)}

\item{tau}{Vector of quantiles to be estimated. Default is 0.5}

\item{reverse}{Logical, default is \code{FALSE}. Should reps be used as predictor instead as a target?}

\item{control}{Control object for the \code{\link[quantreg]{nlrq}} function. Default is:
\code{quantreg::nlrq.control(maxiter = 10^4, InitialStepSize = 0)}}

\item{...}{Forwarded to \code{\link[quantreg]{nlrq}} function}

\item{weight}{Weight used}

\item{k}{Value for the generic Epley's equation, which is by default equal to 0.0333}
}
\value{
\code{\link[quantreg]{nlrq}} object
}
\description{
These functions provide estimate 1RM and parameter values using the quantile regression. By default,
target variable is the reps performed, while the predictors is the \code{perc_1RM} or
\code{weight}. To reverse this, use the \code{reverse = TRUE} argument
}
\section{Functions}{
\itemize{
\item \code{estimate_k_quantile()}: Estimate the parameter \code{k} in the Epley's equation

\item \code{estimate_k_generic_1RM_quantile()}: Provides the model with generic \code{k} parameter, as well as
estimated \code{1RM}. This is a novel estimation function that uses the absolute weights

\item \code{estimate_k_1RM_quantile()}: Estimate the parameter \code{k} in the Epley's equation, as well as
\code{1RM}. This is a novel estimation function that uses the absolute weights

\item \code{estimate_kmod_quantile()}: Estimate the parameter \code{kmod} in the modified Epley's equation

\item \code{estimate_kmod_1RM_quantile()}: Estimate the parameter \code{kmod} in the modified Epley's equation, as well as
\code{1RM}. This is a novel estimation function that uses the absolute weights

\item \code{estimate_klin_quantile()}: Estimate the parameter \code{klin} in the Linear/Brzycki equation

\item \code{estimate_klin_1RM_quantile()}: Estimate the parameter \code{klin} in the Linear/Brzycki equation, as well as
\code{1RM}. This is a novel estimation function that uses the absolute weights

}}
\examples{
# ---------------------------------------------------------
# Epley's model
m1 <- estimate_k_quantile(
  perc_1RM = c(0.7, 0.8, 0.9),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Epley's model that also estimates 1RM
m1 <- estimate_k_generic_1RM_quantile(
  weight = c(70, 110, 140),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Epley's model that also estimates 1RM
m1 <- estimate_k_1RM_quantile(
  weight = c(70, 110, 140),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Modified Epley's model
m1 <- estimate_kmod_quantile(
  perc_1RM = c(0.7, 0.8, 0.9),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Modified Epley's model that also estimates 1RM
m1 <- estimate_kmod_1RM_quantile(
  weight = c(70, 110, 140),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Linear/Brzycki model
m1 <- estimate_klin_quantile(
  perc_1RM = c(0.7, 0.8, 0.9),
  reps = c(10, 5, 3)
)

coef(m1)
# ---------------------------------------------------------
# Linear/Brzycki model thal also estimates 1RM
m1 <- estimate_klin_1RM_quantile(
  weight = c(70, 110, 140),
  reps = c(10, 5, 3)
)

coef(m1)
}
