% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration_adaptiveSSD.R
\name{integration_adaptiveSSD}
\alias{integration_adaptiveSSD}
\title{SSRT using integration method for studies with "adaptive" method of setting SSD}
\usage{
integration_adaptiveSSD(df, stop_col, rt_col, acc_col, ssd_col)
}
\arguments{
\item{df}{Dataframe with response time, accuracy, indication whether trial is stop or go, and delays for a given trial.}

\item{stop_col}{Name of the column in the dataframe \code{df} that indicates whether a given trial is a "stop" or a "go" trial ( 0 = go, 1 = stop)}

\item{rt_col}{Name of the column in the dataframe \code{df} that contains response time in seconds}

\item{acc_col}{Name of the column in the dataframe \code{df} that contains accuracy of inhibition ( 0 = incorrect, 1 = correct)}

\item{ssd_col}{Name of the column in the dataframe \code{df} that contains stop-signal delays}
}
\value{
SSRT corresponding to the \code{ nth rt - ssd; n = p(respond|signal)*number of goRTs}
}
\description{
Estimating SSRT using integration method for studies that use adaptive (increasing/decreasing by a given increment) stop-signal delays.
}
\examples{
data(adaptive)
sapply(split(adaptive, adaptive$new_id), integration_adaptiveSSD, stop_col = 'vol',
ssd_col = 'soa', rt_col = 'RT_exp', acc_col = 'correct')
}
