#' Placebos and pain relief
#'
#' Pain relief from analgesics and placebos.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 7 rows (each time point) and 6 columns:
#' \describe{
#'   \item{Time}{The time after taking the treatment, in hours}
#'   \item{Placebo}{The mean pain relief score for 22 patients given placebos}
#'   \item{Distr}{The mean pain relief score for 22 patients given distalgesics}
#'   \item{Asp}{The mean pain relief score for 22 patients given aspirin}
#'   \item{Codis}{The mean pain relief score for 22 patients given codis}
#'   \item{PlaceboRed}{The mean pain relief score for 22 patients given red placebos}
#' }
#' @source 
#' Read from Figures 3 and 4 of Huskisson, E. C. 1974.
#' Simple Analgesics for Arthritis. 
#' \emph{British Medical Journal} \bold{4}: 196--200.
#' 
#' @usage 
#' data(Placebos)
#' 
#' @examples
#' plot( Asp ~ Time, 
#'       data = Placebos, 
#'       type = "l", 
#'       lty = 1, 
#'       xlab = "Time (hrs)", 
#'       ylab = "Pain relief score")
#' lines( Placebo ~ Time, 
#'        data = Placebos, 
#'        lty = 2)
#' 

"Placebos"
