% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{getroc}
\alias{getroc}
\title{getroc()
Comprehensive plotting function for receiver-operator characteristic curve. Also calculates AUROC and standard error.}
\usage{
getroc(y, ypred, cv = NULL, res = 100)
}
\arguments{
\item{y}{class labels, 0/1 or logical}

\item{ypred}{predictions Pr(Y=1), numeric vector}

\item{cv}{cross-validation fold assignments, if relevant. Changes estimate of standard error.}

\item{res}{resolution. Returns this many equally-spaced points along the curve. Set res to null to return all points.}
}
\value{
list containing: spec, specificity for res points in every cv fold; sens, sensitivity for res points in every cv fold; auc, areas under the curve for each fold and average (note length is 1 greater than number of CV folds); se, standard error for AUC in each fold and standard error for average auc (note length is 1 greater than number of CV folds)
}
\description{
Rather than returning points corresponding to every cutoff, only returns a representative sample of equally-spaced points along the curve.
}
\details{
SE of AUROC with no CV structure is from Hanley and McNeil 1982. SE of AUROC with CV folds is from LeDell et al 2012

Does not plot anything. Object can be plotted in a default way.
}
\examples{
# See vignette
}
