% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_calc.R
\name{region_calc}
\alias{region_calc}
\title{Functional groups calculation}
\usage{
region_calc(
  batch_nmr = NULL,
  file = NULL,
  NMRmeth = NULL,
  FixNC,
  NMR_field = NULL,
  NMR_rotation = NULL,
  ecosys = NULL,
  cndata = NULL,
  mod_std = NULL
)
}
\arguments{
\item{batch_nmr}{Vector with file names, default}

\item{file}{The raw  file}

\item{NMRmeth}{Regions to be integrated, methods available include: "4region", "Bonanomi", "Smernik" and Molecular mixing model ("MMM").}

\item{FixNC}{TRUE or FALSE, for fixing or not the NC ratio on the sample fitting.}

\item{NMR_field}{Magnetic field of the NMR}

\item{NMR_rotation}{Rotation frequency of the sample probe in the NMR}

\item{ecosys}{Standards to be used for the MMM, can be Terrestrial("Terr_Nelson" or "Terr_Baldock") or Aquatic ("Aqua_Nelson" or "Aqua_Baldock")}

\item{cndata}{The N:C data file created with mk_nc_data}

\item{mod_std}{File containing a modified NMR table}
}
\value{
A data frame that contains the SSBs corrected C functional groups, or if the "MMM" method is selected, the result of the fitting of the "MMM".
}
\description{
This function loads, integrates and calculates the functional group distribution from the raw spectra.
Produces also the molecular mixing model fitting if NC data is provided.
Output is a list with the raw data, integrals and corrected spectra.
}
\examples{
data("GarciaF200")
IntegralSSBc <- region_calc(GarciaF200, NMRmeth = "4region", NMR_field = 200, NMR_rotation = 6800)
}
\keyword{Bonanomi}
\keyword{Mixing}
\keyword{Molecular}
\keyword{fitting}
\keyword{model}
