% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_LCF.r
\name{fit_LCF}
\alias{fit_LCF}
\title{Porting for linear combination fitting}
\usage{
fit_LCF(
  all.samples,
  all.standards,
  ecosys = NULL,
  amoSTD,
  ex.smaller = NULL,
  file.output = NULL,
  best.fits = NULL,
  NMRmeth,
  FixNC
)
}
\arguments{
\item{all.samples}{List of all samples}

\item{all.standards}{List of all standards}

\item{ecosys}{Standards to be used for the MMM, can be Terrestrial("Terr_Nelson" or "Terr_Baldock") or Aquatic ("Aqua_Nelson" or "Aqua_Baldock")}

\item{amoSTD}{Use at most X standards}

\item{ex.smaller}{Exclude portions smaller than a given value (decimal form), default to NULL}

\item{file.output}{Possibility to have a file output, default to NULL}

\item{best.fits}{Possibility to output more than the best fit (e.g. the first 10 best fits), default to 1}

\item{NMRmeth}{Regions to be integrated, methods available include: "4region", "Bonanomi", "Smernik" and Molecular mixing model ("MMM").}

\item{FixNC}{TRUE or FALSE, for fixing or not the NC ratio on the sample fitting.}
}
\value{
A dataframe containing the result of the fitting exercise for all files.
}
\description{
The function can be used to check which combinations of standards produce a good fit.
}
\keyword{correction}
\keyword{normalization}
