% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.stream.dist.R
\name{calc.stream.dist}
\alias{calc.stream.dist}
\title{Calculate distance along a stream}
\usage{
calc.stream.dist(p1, p2, data)
}
\arguments{
\item{p1}{(numeric vector) Longitude and latitude (in that order) of first point}

\item{p2}{(numeric vector) Longitude and latitude (in that order) of second point}

\item{data}{(list) Output from \code{\link{prep.data}}.}
}
\value{
(numeric) Distance (in meters) between the two points
}
\description{
Calculate the shortest distance along a stream network between a pair of points
}
\details{
This is the primary function for calculating the shortest distance between two points along the stream network.
}
\examples{

data(stream.line)
data(nodes)
data(animal.points)

network.20 <- prep.data(
  l = stream.line,
  freq = 20,
  nodes = nodes,
  lon.name = "lon",
  lat.name = "lat",
  node.name = "id"
)

calc.stream.dist(p1 = c(-88.99845, 17.17668),
 p2 = c(-88.99838, 17.17710),
 data=network.20)


}
