% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copt.R
\name{copt}
\alias{copt}
\title{Calculate the c-optimal design under the SLSE with the given combination of the parameters}
\usage{
copt(N, u, tt, FUN, theta, num_iter = 1000, cVec)
}
\arguments{
\item{N}{The number of sample points in the design space.}

\item{u}{The discretized design space.}

\item{tt}{The level of skewness. When tt=0, it is equivalent to compute the c-optimal design under the ordinary least squares estimator.}

\item{FUN}{The function to calculate the derivative of the given model.}

\item{theta}{The parameter value of the model.}

\item{num_iter}{Maximum number of iteration.}

\item{cVec}{c vector used to determine the combination of the parameters}
}
\value{
A list that contains 1. Value of the objective function at solution. 2. Status. 3. Optimal design
}
\description{
Calculate the c-optimal design under the SLSE with the given combination of the parameters
}
\details{
This function calculates the c-optimal design and the loss function under the c-optimality. The loss function under c-optimality is defined as the log determinant of the inverse of the Fisher information matrix.
}
\examples{
poly3 <- function(xi, theta){
  matrix(c(1, xi, xi^2, xi^3), ncol = 1)
}
Npt <- 101
my_design <- copt(N = Npt, u = seq(-1, +1, length.out = Npt),
   tt = 0, FUN = poly3, theta = rep(0,4), num_iter = 2000,
   cVec = c(0,1,1,1))
round(my_design$design, 3)
my_design$val

}
