% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.SLOPE}
\alias{summary.SLOPE}
\title{Summarize SLOPE Model}
\usage{
\method{summary}{SLOPE}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"SLOPE"}, typically from a call to
\code{\link[=SLOPE]{SLOPE()}}}

\item{...}{other arguments (currently ignored)}
}
\value{
An object of class \code{"summary_SLOPE"} with the following components:
\item{call}{the call that produced the model}
\item{family}{the model family}
\item{n_obs}{number of observations}
\item{n_predictors}{number of predictors}
\item{has_intercept}{whether an intercept was fit}
\item{path_length}{number of steps in the regularization path}
\item{alpha_range}{range of alpha values in the path}
\item{deviance_ratio_range}{range of deviance ratios in the path}
\item{null_deviance}{null deviance}
\item{path_summary}{data frame summarizing the regularization path}
}
\description{
Produces a summary of a fitted SLOPE model, including information about
the regularization path, model family, and fitted values.
}
\examples{
fit <- SLOPE(heart$x, heart$y)
summary(fit)

# Multinomial example
fit_multi <- SLOPE(wine$x, wine$y, family = "multinomial")
summary(fit_multi)

}
\seealso{
\code{\link[=SLOPE]{SLOPE()}}, \code{\link[=print.summary_SLOPE]{print.summary_SLOPE()}}

Other SLOPE-methods: 
\code{\link{coef.SLOPE}()},
\code{\link{deviance.SLOPE}()},
\code{\link{plot.SLOPE}()},
\code{\link{predict.SLOPE}()},
\code{\link{print.SLOPE}()},
\code{\link{score}()}
}
\concept{SLOPE-methods}
