% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{partition}
\alias{partition}
\title{Create Partitions of an RI array.}
\usage{
partition(array, alpha = 0.05, .debug = FALSE)
}
\arguments{
\item{array}{Vector of refractive indices.}

\item{alpha}{Significance parameter "[0,1]". Higher values are more likely to partition the
array further.}

\item{.debug}{Runs debugging.}
}
\value{
sk_partition_tree
}
\description{
Partitions the array of assumed glass fragment refractive indices into statistically
significant groups.
}
\examples{

set.seed(123)
ris = generate_indices(8, 4)
part = partition(ris)
plot(part)
part$groups


}
