% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linter.R
\name{lint_ns}
\alias{lint_ns}
\title{Check the \code{{shiny}} module UI functions for \code{ns()} omission}
\usage{
lint_ns(path = curr_proj(), ...)
}
\arguments{
\item{path}{\emph{character}, path to the package root directory. Default is the
current project’s directory.}

\item{...}{
  Arguments passed on to \code{\link[lintr:lint]{lintr::lint_package}}
  \describe{
    \item{\code{parse_settings}}{Logical, default \code{TRUE}. Whether to try and parse the \link[lintr:read_settings]{settings}. Otherwise,
the \code{\link[lintr:default_settings]{default_settings()}} are used.}
    \item{\code{relative_path}}{if \code{TRUE}, file paths are printed using their path relative to the base directory.
If \code{FALSE}, use the full absolute path.}
    \item{\code{exclusions}}{exclusions for \code{\link[lintr:exclude]{exclude()}}, relative to the package path.}
    \item{\code{show_progress}}{Logical controlling whether to show linting progress with a simple text
progress bar \emph{via} \code{\link[utils:txtProgressBar]{utils::txtProgressBar()}}. The default behavior is to show progress in
\code{\link[=interactive]{interactive()}} sessions not running a testthat suite.}
  }}
}
\value{
An object of class c("lints", "list"), each element of which is a "list" object.
}
\description{
This is a simple wrapper of \code{\link[lintr:lint]{lintr::lint_package()}} call using only the
\code{\link[=module_namespace_linter]{module_namespace_linter()}} from \code{{SIAtools}}. See the
\link[=module_namespace_linter]{linter documentation} for more details.
}
\examples{
\dontrun{
lint_ns()
}

}
\seealso{
Other linter-related functions:
\code{\link{module_namespace_linter}()}
}
\concept{linters}
